<?php
/**
 * Concord CRM - https://www.concordcrm.com
 *
 * @version   1.6.0
 *
 * @link      Releases - https://www.concordcrm.com/releases
 * @link      Terms Of Service - https://www.concordcrm.com/terms
 *
 * @copyright Copyright (c) 2022-2025 KONKORD DIGITAL
 */

namespace Modules\Updater\Exceptions;

use Exception;
use Illuminate\Http\Response;

class PurchaseKeyUsedException extends UpdaterException
{
    /**
     * Initialize new PurchaseKeyUsedException instance
     *
     * @param  string  $message
     * @param  int  $code
     */
    public function __construct($message = '', $code = 0, ?Exception $previous = null)
    {
        parent::__construct(
            'Purchase key already used to download the files for the requested release.',
            Response::HTTP_CONFLICT,
            $previous
        );
    }
}
